local assets =
{
	Asset("ANIM", "anim/ghost.zip"),
	Asset("ANIM", "anim/ghost_wendy_build.zip"),
	Asset("SOUND", "sound/ghost.fsb"),
}

local prefabs = 
{
  "shovel"
}

local function auratest(inst, target)

    if target == GetPlayer() then return false end

    local leader = inst.components.follower.leader
    if target.components.combat.target and ( target.components.combat.target == inst or target.components.combat.target == leader) then return true end
    if inst.components.combat.target == target then return true end

    if leader then
        if leader == target then return false end
        if target.components.follower and target.components.follower.leader == leader then return false end
    end

    return target:HasTag("monster") or target:HasTag("prey")
end

local function updatedamage(inst)
    if GetClock():IsDay() then
        inst.components.combat.defaultdamage = TUNING.ABIGAIL_DAMAGE_PER_SECOND 
    elseif GetClock():IsNight() then
        inst.components.combat.defaultdamage = 3*TUNING.ABIGAIL_DAMAGE_PER_SECOND 
        inst.components.health:SetVal(325)		
    elseif GetClock():IsDusk() then
        inst.components.combat.defaultdamage = 1.5*TUNING.ABIGAIL_DAMAGE_PER_SECOND 
    end
end

local function OnAttacked(inst, data)
   if inst.components.health.currenthealth < 100 then
   inst.AnimState:SetMultColour(0.7,0.1,0.1,0.2)
	elseif inst.components.health.currenthealth > 101 then
    local i = inst.components.health.currenthealth/325
	local d = i*0.7
    local r = 1-(i*1.3)
    inst.AnimState:SetMultColour(i,d,d,r)
   end
end


local function EquipWeapon(inst)
    if inst.components.inventory and not inst.components.inventory:GetEquippedItem(EQUIPSLOTS.HANDS) then
        local weapon = CreateEntity("shovel")
        weapon.entity:AddTransform()
        weapon:AddComponent("weapon")
        weapon.components.weapon:SetDamage(inst.components.combat.defaultdamage)
        weapon.components.weapon:SetRange(inst.components.combat.attackrange, inst.components.combat.attackrange+4)
        weapon.components.weapon:SetProjectile("bishop_charge")
        weapon:AddComponent("inventoryitem")
        weapon.persists = false
        weapon:AddComponent("equippable")
        inst.components.inventory:Equip(weapon)
    end
end

local function ontalk(inst, script)
	inst.SoundEmitter:PlaySound("dontstarve/ghost/ghost_girl_howl_LP")
end


local function OnOpen(inst)
    if not inst.components.health:IsDead() then
        inst.sg:GoToState("open")
    end
end 

local function OnClose(inst) 
    if not inst.components.health:IsDead() then
        inst.sg:GoToState("close")
    end
end 

local slotpos = {}

for y = 0, 6 do
	table.insert(slotpos, Vector3(-162, -y*75 + 240 ,0))
	table.insert(slotpos, Vector3(-162 +75, -y*75 + 240 ,0))
end



local function ondeath(inst, deadthing)
if inst.components.health.currenthealth > 0 then
    if inst:GetDistanceSqToInst(deadthing) < 10*10 then
	inst.components.health:DoDelta(deadthing.components.health.maxhealth/2)
	end
    if inst:GetDistanceSqToInst(deadthing) < 25*25 then
	inst.components.hunger:DoDelta(deadthing.components.health.maxhealth/3)
	inst.components.hunger:DoDelta(10)
    if inst.components.hunger.current > 71 then
    inst.AnimState:SetMultColour(1,1,1,.4)
    end
	end
end
end



local function fn(Sim)
	local inst = CreateEntity()
	local trans = inst.entity:AddTransform()
	local anim = inst.entity:AddAnimState()
	local sound = inst.entity:AddSoundEmitter()
    local light = inst.entity:AddLight()

    MakeGhostPhysics(inst, 1, .5)
    
    light:SetIntensity(.4)
    light:SetRadius(.5)
    light:SetFalloff(.6)
    light:Enable(true)
    light:SetColour(180/255, 195/255, 225/255)
    
    local brain = require "brains/wilsonbrain"
    inst:SetBrain(brain)
    
    anim:SetBank("ghost")
    anim:SetBuild("ghost_wendy_build")
    anim:SetBloomEffectHandle( "shaders/anim.ksh" )
    anim:PlayAnimation("idle", true)
    inst.AnimState:SetMultColour(1,1,1,.4)
    
    --inst:AddTag("monster")
    inst:AddTag("scarytoprey")
    inst:AddTag("girl")
    inst:AddTag("ghost")
    inst:AddTag("noauradamage")
    inst:AddTag("notraptrigger")
	inst:AddTag("playerfriends")

    inst:AddComponent("locomotor") -- locomotor must be constructed before the stategraph
    inst.components.locomotor.walkspeed = TUNING.ABIGAIL_SPEED*1.6
    inst.components.locomotor.runspeed = TUNING.ABIGAIL_SPEED*1.6
    
    inst:SetStateGraph("SGghost_2")

    
----    inst:AddComponent("inspectable")
    inst:AddComponent("talker")
	
    inst:AddComponent("health")
    inst.components.health:SetMaxHealth(325)
    inst.components.health:StartRegen(6, 1)

    inst:AddComponent("hunger")
    inst.components.hunger:SetMax(TUNING.WILSON_HUNGER)
    inst.components.hunger:SetRate(TUNING.WILSON_HUNGER_RATE)
    inst.components.hunger:SetKillRate(TUNING.WILSON_HEALTH/TUNING.STARVE_KILL_TIME)



	inst:AddComponent("combat")
    inst.components.combat.defaultdamage = TUNING.ABIGAIL_DAMAGE_PER_SECOND
    inst.components.combat.playerdamagepercent = 50
    inst.components.combat.hiteffectsymbol = "waist"
    inst.components.combat:SetAttackPeriod(TUNING.BISHOP_ATTACK_PERIOD/2)
    inst.components.combat:SetRange(TUNING.BISHOP_ATTACK_DIST)
	
	
	
    inst:AddComponent("talker")
    inst.components.talker.ontalk = ontalk



    inst:AddComponent("aura")
    inst.components.aura.radius = 3
    inst.components.aura.tickperiod = 1.5
    inst.components.aura.ignoreallies = true
    inst.components.aura.auratestfn = auratest
    
    inst:AddComponent("lootdropper")
 -----   inst.components.lootdropper:SetLoot({"abigail_flower"})
    ------------------    
    
    inst:AddComponent("inventory")

	
    inst.SoundEmitter:PlaySound("dontstarve/ghost/ghost_girl_howl_LP", "howl")
    
    inst:AddComponent("follower")
	local player = GetPlayer()
	if player and player.components.leader then
		player.components.leader:AddFollower(inst)
	end
	
	
    inst:AddComponent("playercontroller_2")
------    inst:AddComponent("playeractionpicker")


    inst:AddComponent("talker")
    --inst.components.talker.ontalk = ontalk
    
    inst.entity:AddLabel()
    inst.Label:SetFontSize(30)
    inst.Label:SetFont(TALKINGFONT)
    inst.Label:SetColour(.9, .4, .4, 1)
    inst.Label:SetPos(0,2.5,0)

	inst:AddComponent("combat")
	
	inst:AddComponent("container")
---    inst.components.container.onopenfn = OnOpen
---    inst.components.container.onclosefn = OnClose

    inst.components.container:SetNumSlots(16)
    inst.components.container.widgetslotpos = slotpos
    inst.components.container.widgetanimbank = "ui_krampusbag_2x8"
    inst.components.container.widgetanimbuild = "ui_krampusbag_2x8"
    --inst.components.container.widgetpos = Vector3(645,-85,0)
    inst.components.container.widgetpos = Vector3(-5,-75,0)
    

    inst:ListenForEvent("entity_death", function(world, data) ondeath(inst, data.inst) end, GetWorld())

	--inst:ListenForEvent( "daytime", function(tgi, data) inst.components.health:SetVal(0) end, GetWorld())
    inst:ListenForEvent( "dusktime", function() updatedamage(inst) end , GetWorld())
    inst:ListenForEvent( "daytime", function() updatedamage(inst) end , GetWorld())
    inst:ListenForEvent( "nighttime", function() updatedamage(inst) end , GetWorld())
    inst:ListenForEvent("attacked", OnAttacked)    


    updatedamage(inst)
	EquipWeapon(inst)
    return inst
end


return Prefab( "common/monsters/ghostplayer", fn, assets, prefabs ) 
